﻿/*
── Project ─────────────────────────────────────────────────────────────────────

Name:        RoyalPrince_SMC
Version:     1.00
Date:        2025
Repository:  Available @ https://fxcodebase.com/code/viewtopic.php?f=38&t=76432&p=161150#p161150
License:     GNU

── Author ──────────────────────────────────────────────────────────────────────

Developed by: Mario Jemic
Email:        mario.jemic@gmail.com
Website:      https://mario-jemic.com

── Support & Donations ─────────────────────────────────────────────────────────

PayPal:      https://goo.gl/9Rj74e
Patreon:     https://tiny.cc/1ybwxz
BuyMeACoffee:https://tiny.cc/bj7vzj

Crypto:
 BTC : 16F5k43RXibTmna4np8bPVgmXM1CzjXFJJ
 SOL : 3nh5rpUKopcYLNU4zGCdUFAkM3iRQq8VVUmuzVG6VDf2
 ETH/BNB/USDT/XRP (ERC20/BEP20): 0xe53aab6bc468a963a02d1319660ee60cf80fc8e7

── Copyright ───────────────────────────────────────────────────────────────────

© 2025 Gehtsoft USA LLC — https://fxcodebase.com

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 <https://www.gnu.org/licenses/>.
*/
//+------------------------------------------------------------------+
//|                                              RoyalPrince_SMC.mq4 |
//|                  Copyright 2025 Gehtsoft USA LLC & Mario Jemic   |
//+------------------------------------------------------------------+
#property copyright "Copyright © 2025, Gehtsoft USA LLC"
#property link      "http://fxcodebase.com"
#property strict
#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots   1
#property indicator_label1  "AMA"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  2

//--- Inputs
input string Mode                  = "Historical";
input string Style                 = "Colored";
input color  AMAColor              = clrCrimson;
input bool   ShowTrend             = false;
input bool   ShowInternals         = true;
input string ShowIBull             = "All";
input color  SwingIBullColor       = clrGreen;
input string ShowIBear             = "All";
input color  SwingIBearColor       = clrRed;
input bool   IFilterConfluence     = false;
input string InternalStructureSize = "Tiny";
input bool   ShowStructure         = true;
input string ShowBull              = "All";
input color  SwingBullColor        = clrGreen;
input string ShowBear              = "All";
input color  SwingBearColor        = clrRed;
input string SwingStructureSize    = "Small";
input bool   ShowSwings            = false;
input int    SwingLength           = 50;
input bool   ShowHLSwings          = true;
input bool   ShowIOB               = true;
input int    IOBShowLast           = 5;
input bool   ShowOB                = false;
input int    OBShowLast            = 5;
input string OBFilter              = "Atr";
input color  IBullOBColor          = clrDodgerBlue;
input color  IBearOBColor          = clrLightPink;
input color  BullOBColor           = clrBlue;
input color  BearOBColor           = clrDarkRed;
input bool   ShowEQ                = true;
input int    EQLen                 = 3;
input double EQThreshold           = 0.1;
input string EQSize                = "Tiny";
input bool   ShowFVG               = false;
input bool   FVGAuto               = true;
input string FVGTF                 = "";
input color  BullFVGColor          = clrLimeGreen;
input color  BearFVGColor          = clrRed;
input int    FVGExtend             = 1;
input bool   ShowPDHL              = false;
input string PDHLStyle             = "Solid";
input color  PDHLColor             = clrBlue;
input bool   ShowPWHL              = false;
input string PWHLStyle             = "Solid";
input color  PWHLColor             = clrBlue;
input bool   ShowPMHL              = false;
input string PMHLStyle             = "Solid";
input color  PMHLColor             = clrBlue;
input bool   ShowSD                = false;
input color  PremiumColor          = clrRed;
input color  EQZoneColor           = clrGray;
input color  DiscountColor         = clrGreen;
input double K_Slope               = 1.0;
input string SlopeMethod           = "Atr";
input bool   ShowOnlyConfirmed     = true;

//Forex-Station button template start41; copy and paste
extern string             button_note1          = "(===||::::::::::::::::::::::::::::::::::::::::::::::>";
extern int                btn_Subwindow         = 0;                               // What window to put the button on.  If <0, the button will use the same sub-window as the indicator.
extern ENUM_BASE_CORNER   btn_corner            = CORNER_LEFT_UPPER;               // button corner on chart for anchoring
extern string             btn_text              = "SMC";                           // a button name
extern string             btn_Font              = "Arial";                         // button font name
extern int                btn_FontSize          = 9;                               // button font size               
extern color              btn_text_ON_color     = clrLime;                         // ON color when the button is turned on
extern color              btn_text_OFF_color    = clrRed;                          // OFF color when the button is turned off
extern color              btn_background_color  = clrDimGray;                      // background color of the button
extern color              btn_border_color      = clrBlack;                        // border color the button
extern int                button_x              = 20;                              // x coordinate of the button     
extern int                button_y              = 175;                             // y coordinate of the button     
extern int                btn_Width             = 80;                              // button width
extern int                btn_Height            = 20;                              // button height
extern string             UniqueButtonID        = "Royal";                         // Unique ID for each button        
extern string             button_note2          = "(===||::::::::::::::::::::::::::::::::::::::::::::::>";

//--- ON/OFF Control
bool   ForceFullRedraw  = false;
bool   IndicatorEnabled = true;
string ButtonName       = "RoyalPrince_ToggleBtn";
string GV_Name          = "RoyalPrince_SMC_Enabled";
//Forex-Station button template end41; copy and paste

//--- Global variables
double AMABuffer[];
int    trend = 0, itrend = 0;
double top_y = 0, btm_y = 0;
int    top_x = 0, btm_x = 0;
double itop_y = 0, ibtm_y = 0;
int    itop_x = 0, ibtm_x = 0;
double trail_up = 0, trail_dn = 0;
int    trail_up_x = 0, trail_dn_x = 0;
bool   top_cross = true, btm_cross = true;
bool   itop_cross = true, ibtm_cross = true;
double atr_value = 0;
double cmean_range = 0;

double iob_top[], iob_btm[];
datetime iob_left[];
int    iob_type[];
int    iob_size = 0;

double ob_top[], ob_btm[];
datetime ob_left[];
int    ob_type[];
int    ob_size = 0;

double eq_prev_top = 0, eq_prev_btm = 0;
int    eq_top_x = 0, eq_btm_x = 0;

string bullish_fvg_names[], bearish_fvg_names[];
int    bull_fvg_count = 0, bear_fvg_count = 0;

string structure_line_names[];
double structure_line_prices[];
int    structure_line_count = 0;

string prefix = "RoyalPrince_";
int    object_counter = 0;

//+------------------------------------------------------------------+
//| Initialization                                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   SetIndexBuffer(0, AMABuffer);
   SetIndexStyle(0, DRAW_LINE, STYLE_SOLID, 2, AMAColor);
   SetIndexLabel(0, "AMA");

   // === THIS IS THE KEY FIX: ONLY FORCE ON IF NEVER USED BEFORE ===
   if(GlobalVariableCheck(GV_Name))
     {
      IndicatorEnabled = (GlobalVariableGet(GV_Name) > 0.5);
      Print("RoyalPrince SMC - LOADED SAVED STATE: ", IndicatorEnabled?"ON":"OFF");
     }
   else
     {
      GlobalVariableSet(GV_Name, 1.0);
      IndicatorEnabled = true;
      Print("RoyalPrince SMC - FIRST TIME USE - DEFAULT ON");
     }

   CreateToggleButton();
   UpdateButtonText();

   ArrayResize(iob_top,100); ArrayResize(iob_btm,100);
   ArrayResize(iob_left,100); ArrayResize(iob_type,100);
   ArrayResize(ob_top,100); ArrayResize(ob_btm,100);
   ArrayResize(ob_left,100); ArrayResize(ob_type,100);
   ArrayResize(bullish_fvg_names,50);
   ArrayResize(bearish_fvg_names,50);
   ArrayResize(structure_line_names,100);
   ArrayResize(structure_line_prices,100);

   Print("RoyalPrince SMC LOADED");

   IndicatorShortName("RoyalPrince SMC");
   EventSetTimer(1);
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Timer                                                            |
//+------------------------------------------------------------------+
void OnTimer()
  {
   ChartRedraw();
   static int c=0; c++; if(c>5) EventKillTimer();
  }

//+------------------------------------------------------------------+
//| Deinitialization                                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   EventKillTimer();
   ObjectDelete(ButtonName);
  }

//+------------------------------------------------------------------+
//| Chart Event                                                      |
//+------------------------------------------------------------------+
void OnChartEvent(const int id, const long &lparam, const double &dparam, const string &sparam)
  {
   if(id==CHARTEVENT_OBJECT_CLICK && sparam==ButtonName)
     {
      bool was_enabled = IndicatorEnabled;
      IndicatorEnabled = !IndicatorEnabled;
      GlobalVariableSet(GV_Name, IndicatorEnabled?1:0);
      UpdateButtonText();
      ObjectSetInteger(0,ButtonName,OBJPROP_STATE,false);

      if(!IndicatorEnabled)
        {
         DeleteAllIndicatorObjects();
         Print("RoyalPrince SMC turned OFF");
        }
      else
        {
         Print("RoyalPrince SMC turned ON - FORCING FULL REDRAW + ORDER BLOCKS");
         ForceFullRedraw = true;
        }

      ChartRedraw();
      if(IndicatorEnabled && !was_enabled)
        {
         ForceFullRedraw = true;
         ChartRedraw();
        }
     }
  }
//+------------------------------------------------------------------+
//| Create Toggle Button                                             |
//+------------------------------------------------------------------+
void CreateToggleButton()
{
      if(ObjectFind(ButtonName)>=0) ObjectDelete(ButtonName);
      ObjectCreate    (0,ButtonName,OBJ_BUTTON,btn_Subwindow,0,0);
      ObjectSetInteger(0,ButtonName,OBJPROP_COLOR,btn_text_ON_color);
      ObjectSetInteger(0,ButtonName,OBJPROP_BGCOLOR,btn_background_color);
      ObjectSetInteger(0,ButtonName,OBJPROP_BORDER_COLOR,btn_border_color);
      ObjectSetInteger(0,ButtonName,OBJPROP_BORDER_TYPE,BORDER_RAISED);
      ObjectSetInteger(0,ButtonName,OBJPROP_XSIZE,btn_Width);
      ObjectSetInteger(0,ButtonName,OBJPROP_YSIZE,btn_Height);
      ObjectSetString (0,ButtonName,OBJPROP_FONT,btn_Font);
      ObjectSetString (0,ButtonName,OBJPROP_TEXT,btn_text);
      ObjectSetInteger(0,ButtonName,OBJPROP_FONTSIZE,btn_FontSize);
      ObjectSetInteger(0,ButtonName,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,ButtonName,OBJPROP_CORNER,btn_corner);
      ObjectSetInteger(0,ButtonName,OBJPROP_HIDDEN,1);
      ObjectSetInteger(0,ButtonName,OBJPROP_XDISTANCE,button_x);
      ObjectSetInteger(0,ButtonName,OBJPROP_YDISTANCE,button_y);
      // Upon creation, set the initial state to "true" which is "on", so one will see the indicator by default
      ObjectSetInteger(0, ButtonName, OBJPROP_STATE, true);
   UpdateButtonText();
}
//+------------------------------------------------------------------+
//| Update Button Text                                               |
//+------------------------------------------------------------------+
void UpdateButtonText()
  {
   ObjectSetString(0,ButtonName,OBJPROP_TEXT,"SMC "+(IndicatorEnabled?"ON":"OFF"));
//   ObjectSetInteger(0,ButtonName,OBJPROP_BGCOLOR,IndicatorEnabled?clrGreen:clrRed);
   ObjectSetInteger(0,ButtonName,OBJPROP_COLOR,IndicatorEnabled?btn_text_ON_color:btn_text_OFF_color);
  }

//+------------------------------------------------------------------+
//| Main Calculation                                                 |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   if(!IndicatorEnabled)
     {
      ArrayInitialize(AMABuffer, EMPTY_VALUE);
      return(rates_total);
     }

   // FORCE FULL RECALCULATION WHEN TURNING ON
   int limit;
   if(ForceFullRedraw || prev_calculated==0)
     {
      limit = rates_total-1;
      ForceFullRedraw = false;
      Print("FULL RECALCULATION + DRAWING ORDER BLOCKS NOW");
     }
   else
     {
      limit = rates_total-prev_calculated;
      if(limit<0) limit = rates_total-1;
     }

   ArraySetAsSeries(time,true);
   ArraySetAsSeries(open,true);
   ArraySetAsSeries(high,true);
   ArraySetAsSeries(low,true);
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(AMABuffer,true);

   if(rates_total>200) atr_value=iATR(NULL,0,200,0);

   double sum_range=0;
   int count_bars=MathMin(rates_total,500);
   for(int i=0;i<count_bars;i++) sum_range+=high[i]-low[i];
   if(count_bars>0) cmean_range=sum_range/count_bars;

   for(int i=limit;i>=0;i--)
     {
      CalculateAMA(i,rates_total,high,low,close);
      DetectSwingPoints(i,rates_total,high,low);
      DetectStructureBreaks(i,open,close,high,low,time);
      UpdateTrailing(i,high,low);
      if(ShowFVG && i>=2) DetectFairValueGaps(i,high,low,close,time);
     }

   static datetime last_bar_time=0;
   bool is_new_bar = (Time[0] != last_bar_time);
   if(is_new_bar) last_bar_time = Time[0];

   if(is_new_bar) CleanFilledFVGs(high,low);
   CleanCrossedStructureLines();
   UpdateStructureLines();

   // === THIS IS THE KEY FIX: DRAW ORDER BLOCKS ON EVERY CALL, NOT JUST NEW BAR ===
   CleanOldOrderBlocks();
   if(ShowIOB) DrawOrderBlocks(true, rates_total, time);
   if(ShowOB)  DrawOrderBlocks(false, rates_total, time);

   if(ShowHLSwings)
     {
      string hl_name=prefix+"StrongHigh"; if(ObjectFind(hl_name)>=0) ObjectDelete(hl_name);
      ObjectCreate(hl_name,OBJ_TEXT,0,time[0],trail_up);
      ObjectSetText(hl_name,(trend<0?"Strong High":"Weak High"),8,"Arial",SwingBearColor);
      string ll_name=prefix+"StrongLow"; if(ObjectFind(ll_name)>=0) ObjectDelete(ll_name);
      ObjectCreate(ll_name,OBJ_TEXT,0,time[0],trail_dn);
      ObjectSetText(ll_name,(trend>0?"Strong Low":"Weak Low"),8,"Arial",SwingBullColor);
     }
   if(ShowSD) DrawPremiumDiscountZones(time,rates_total);
   UpdateDynamicTrendlines(rates_total,time,high,low,close);

   if(is_new_bar && rates_total>0)
     {
      if(ShowEQ) DetectEqualHighsLows(rates_total,high,low,time);
      if(ShowPDHL||ShowPWHL||ShowPMHL) DrawMTFHighLow();
     }

   return(rates_total);
  }
//+------------------------------------------------------------------+
//| Delete all indicator objects (button stays)                      |
//+------------------------------------------------------------------+
void DeleteAllIndicatorObjects()
  {
   int total=ObjectsTotal();
   for(int i=total-1;i>=0;i--)
     {
      string name=ObjectName(i);
      if(StringFind(name,prefix)==0 && name!=ButtonName)
         ObjectDelete(name);
     }
   ArrayInitialize(AMABuffer, EMPTY_VALUE);
   ChartRedraw();
  }

//+------------------------------------------------------------------+
//| ALL FUNCTIONS                                                    |
//+------------------------------------------------------------------+
void CalculateAMA(int shift,int rates_total,const double &high[],const double &low[],const double &close[])
  {
   if(shift>=rates_total-SwingLength-1){ AMABuffer[shift]=close[shift]; return; }

   double highest_now=high[shift], lowest_now=low[shift];
   double highest_prev=high[shift+1], lowest_prev=low[shift+1];

   for(int j=0;j<=SwingLength && shift+j<rates_total;j++)
     {
      if(high[shift+j]>highest_now) highest_now=high[shift+j];
      if(low[shift+j]<lowest_now) lowest_now=low[shift+j];
     }
   for(int j=0;j<=SwingLength && shift+j+1<rates_total;j++)
     {
      if(high[shift+j+1]>highest_prev) highest_prev=high[shift+j+1];
      if(low[shift+j+1]<lowest_prev) lowest_prev=low[shift+j+1];
     }

   int hh=(highest_now>highest_prev)?1:0;
   int ll=(lowest_now<lowest_prev)?1:0;
   double tc_input=(hh>0||ll>0)?1.0:0.0;

   static double tc_buffer[];
   static int tc_size=0;
   if(tc_size==0){ ArrayResize(tc_buffer,rates_total); tc_size=rates_total; }
   tc_buffer[shift]=tc_input;

   double tc_sum=0; int count=0;
   for(int j=0;j<SwingLength && shift+j<rates_total;j++){ tc_sum+=tc_buffer[shift+j]; count++; }
   double tc_sma=(count>0)?(tc_sum/count):0;
   double tc=tc_sma*tc_sma;

   if(shift==rates_total-1) AMABuffer[shift]=close[shift];
   else AMABuffer[shift]=AMABuffer[shift+1]+tc*(close[shift]-AMABuffer[shift+1]);
  }

void DetectSwingPoints(int shift,int rates_total,const double &high[],const double &low[])
  {
   if(shift>=SwingLength && shift<rates_total-SwingLength)
     {
      bool is_pivot_high=true; double center=high[shift];
      for(int j=1;j<=SwingLength;j++)
         if(high[shift-j]>=center || high[shift+j]>=center){ is_pivot_high=false; break; }
      if(is_pivot_high)
        {
         top_cross=true; top_y=center; top_x=shift;
         trail_up=center; trail_up_x=shift;
         if(ShowSwings) DrawSwingLabel(shift,center,(center>btm_y||btm_y==0)?"HH":"LH",false);
        }
     }
   if(shift>=SwingLength && shift<rates_total-SwingLength)
     {
      bool is_pivot_low=true; double center=low[shift];
      for(int j=1;j<=SwingLength;j++)
         if(low[shift-j]<=center || low[shift+j]<=center){ is_pivot_low=false; break; }
      if(is_pivot_low)
        {
         btm_cross=true; btm_y=center; btm_x=shift;
         trail_dn=center; trail_dn_x=shift;
         if(ShowSwings) DrawSwingLabel(shift,center,(center<top_y||top_y==0)?"LL":"HL",true);
        }
     }
   if(shift>=5 && shift<rates_total-5)
     {
      bool is_itop=true; double icenter=high[shift];
      for(int j=1;j<=5;j++)
         if(high[shift-j]>=icenter || high[shift+j]>=icenter){ is_itop=false; break; }
      if(is_itop){ itop_cross=true; itop_y=icenter; itop_x=shift; }

      bool is_ibtm=true; double ibcenter=low[shift];
      for(int j=1;j<=5;j++)
         if(low[shift-j]<=ibcenter || low[shift+j]<=ibcenter){ is_ibtm=false; break; }
      if(is_ibtm){ ibtm_cross=true; ibtm_y=ibcenter; ibtm_x=shift; }
     }
  }

void DetectStructureBreaks(int shift,const double &open[],const double &close[],const double &high[],const double &low[],const datetime &time[])
  {
   int array_size=ArraySize(close);
   if(shift<1 || shift+1>=array_size) return;

   if(close[shift]>itop_y && close[shift+1]<=itop_y && itop_cross && top_y!=itop_y)
     {
      bool bull_concordant=true;
      if(IFilterConfluence)
        {
         double body_top=MathMax(close[shift],open[shift]);
         double body_btm=MathMin(close[shift],open[shift]);
         bull_concordant=(high[shift]-body_top)>(body_btm-low[shift]);
        }
      if(bull_concordant)
        {
         bool is_choch=(itrend<0);
         string label=is_choch?"CHoCH":"BOS";
         if(ShowInternals && ShouldShowInternalBull(is_choch))
            DrawStructureLabel(itop_x,itop_y,label,SwingIBullColor,true,false,true);
         itop_cross=false; itrend=1;
         if(ShowIOB) AddOrderBlock(true,false,itop_x,shift);
        }
     }

   if(close[shift]>top_y && close[shift+1]<=top_y && top_cross)
     {
      bool is_choch=(trend<0);
      string label=is_choch?"CHoCH":"BOS";
      if(ShowStructure && ShouldShowSwingBull(is_choch))
         DrawStructureLabel(top_x,top_y,label,SwingBullColor,false,false,false);
      top_cross=false; trend=1;
      if(ShowOB) AddOrderBlock(false,false,top_x,shift);
     }

   if(close[shift]<ibtm_y && close[shift+1]>=ibtm_y && ibtm_cross && btm_y!=ibtm_y)
     {
      bool bear_concordant=true;
      if(IFilterConfluence)
        {
         double body_top=MathMax(close[shift],open[shift]);
         double body_btm=MathMin(close[shift],open[shift]);
         bear_concordant=(high[shift]-body_top)<(body_btm-low[shift]);
        }
      if(bear_concordant)
        {
         bool is_choch=(itrend>0);
         string label=is_choch?"CHoCH":"BOS";
         if(ShowInternals && ShouldShowInternalBear(is_choch))
            DrawStructureLabel(ibtm_x,ibtm_y,label,SwingIBearColor,true,true,true);
         ibtm_cross=false; itrend=-1;
         if(ShowIOB) AddOrderBlock(true,true,ibtm_x,shift);
        }
     }

   if(close[shift]<btm_y && close[shift+1]>=btm_y && btm_cross)
     {
      bool is_choch=(trend>0);
      string label=is_choch?"CHoCH":"BOS";
      if(ShowStructure && ShouldShowSwingBear(is_choch))
         DrawStructureLabel(btm_x,btm_y,label,SwingBearColor,false,true,false);
      btm_cross=false; trend=-1;
      if(ShowOB) AddOrderBlock(false,true,btm_x,shift);
     }
  }

void UpdateTrailing(int shift,const double &high[],const double &low[])
  {
   if(high[shift]>trail_up){ trail_up=high[shift]; trail_up_x=shift; }
   if(low[shift]<trail_dn){ trail_dn=low[shift]; trail_dn_x=shift; }
  }

bool ShouldShowInternalBull(bool is_choch){ return(ShowIBull=="All" || (ShowIBull=="BOS"&&!is_choch) || (ShowIBull=="CHoCH"&&is_choch)); }
bool ShouldShowInternalBear(bool is_choch){ return(ShowIBear=="All" || (ShowIBear=="BOS"&&!is_choch) || (ShowIBear=="CHoCH"&&is_choch)); }
bool ShouldShowSwingBull(bool is_choch){ return(ShowBull=="All" || (ShowBull=="BOS"&&!is_choch) || (ShowBull=="CHoCH"&&is_choch)); }
bool ShouldShowSwingBear(bool is_choch){ return(ShowBear=="All" || (ShowBear=="BOS"&&!is_choch) || (ShowBear=="CHoCH"&&is_choch)); }

void DrawSwingLabel(int bar_shift,double price,string text,bool is_low)
  {
   string name=prefix+"Swing_"+IntegerToString(object_counter++);
   if(ObjectFind(name)>=0) ObjectDelete(name);
   ObjectCreate(name,OBJ_TEXT,0,Time[bar_shift],price);
   ObjectSetText(name,text,8,"Arial",is_low?SwingBullColor:SwingBearColor);
   ObjectSet(name,OBJPROP_BACK,false);
  }

void DrawStructureLabel(int bar_shift,double price,string text,color clr,bool is_internal,bool is_down,bool use_internal_size)
  {
   datetime bar_time=Time[bar_shift];
   string unique_id=TimeToString(bar_time)+"_"+DoubleToString(price,Digits);
   string name=prefix+"Struct_"+unique_id;
   string line_name=prefix+"Line_"+unique_id;
   if(ObjectFind(line_name)>=0) return;

   datetime end_time=Time[0];
   bool found_cross=false;
   for(int scan=bar_shift-1;scan>=0;scan--)
     {
      if(scan>=Bars-1) continue;
      if((Close[scan+1]<price && Close[scan]>=price) || (Close[scan+1]>price && Close[scan]<=price))
        { end_time=Time[scan]; found_cross=true; break; }
     }

   ObjectCreate(line_name,OBJ_TREND,0,bar_time,price,end_time,price);
   ObjectSet(line_name,OBJPROP_COLOR,clr);
   ObjectSet(line_name,OBJPROP_STYLE,is_internal?STYLE_DASH:STYLE_SOLID);
   ObjectSet(line_name,OBJPROP_WIDTH,1);
   ObjectSet(line_name,OBJPROP_RAY,false);
   ObjectSet(line_name,OBJPROP_BACK,true);

   if(!found_cross && bar_shift<50 && structure_line_count<ArraySize(structure_line_names))
     {
      structure_line_names[structure_line_count]=line_name;
      structure_line_prices[structure_line_count]=price;
      structure_line_count++;
     }

   ObjectCreate(name,OBJ_TEXT,0,bar_time,price);
   ObjectSetText(name,text,use_internal_size?7:8,"Arial",clr);
   ObjectSet(name,OBJPROP_BACK,false);
  }

void AddOrderBlock(bool is_internal,bool is_bearish,int pivot_shift,int current_shift)
  {
   int ob_sz=is_internal?iob_size:ob_size;
   double ob_top_val=0, ob_btm_val=99999999;
   datetime ob_time=0;
   double threshold=(OBFilter=="Atr")?atr_value:cmean_range;

   for(int i=pivot_shift;i>=current_shift;i--)
     {
      double candle_range=High[i]-Low[i];
      if(candle_range<threshold*2)
        {
         if(is_bearish)
           {
            if(High[i]>ob_top_val || ob_top_val==0)
              { ob_top_val=High[i]; ob_btm_val=Low[i]; ob_time=Time[i]; }
           }
         else
           {
            if(Low[i]<ob_btm_val)
              { ob_btm_val=Low[i]; ob_top_val=High[i]; ob_time=Time[i]; }
           }
        }
     }

   if(ob_time>0 && ob_top_val>0)
     {
      ob_sz++;
      if(is_internal)
        {
         if(ob_sz>ArraySize(iob_top))
           { ArrayResize(iob_top,ob_sz+10); ArrayResize(iob_btm,ob_sz+10);
             ArrayResize(iob_left,ob_sz+10); ArrayResize(iob_type,ob_sz+10); }
         for(int j=ob_sz-1;j>0;j--)
           { iob_top[j]=iob_top[j-1]; iob_btm[j]=iob_btm[j-1];
             iob_left[j]=iob_left[j-1]; iob_type[j]=iob_type[j-1]; }
         iob_top[0]=ob_top_val; iob_btm[0]=ob_btm_val;
         iob_left[0]=ob_time; iob_type[0]=is_bearish?-1:1;
         iob_size=ob_sz;
        }
      else
        {
         if(ob_sz>ArraySize(ob_top))
           { ArrayResize(ob_top,ob_sz+10); ArrayResize(ob_btm,ob_sz+10);
             ArrayResize(ob_left,ob_sz+10); ArrayResize(ob_type,ob_sz+10); }
         for(int j=ob_sz-1;j>0;j--)
           { ob_top[j]=ob_top[j-1]; ob_btm[j]=ob_btm[j-1];
             ob_left[j]=ob_left[j-1]; ob_type[j]=ob_type[j-1]; }
         ob_top[0]=ob_top_val; ob_btm[0]=ob_btm_val;
         ob_left[0]=ob_time; ob_type[0]=is_bearish?-1:1;
         ob_size=ob_sz;
        }
     }
  }

void DrawGraphicalElements(int rates_total,const datetime &time[],const double &high[],const double &low[],const double &close[])
  {
   CleanOldOrderBlocks();
   if(ShowIOB) DrawOrderBlocks(true,rates_total,time);
   if(ShowOB)  DrawOrderBlocks(false,rates_total,time);
   if(ShowHLSwings)
     {
      string hl_name=prefix+"StrongHigh"; if(ObjectFind(hl_name)>=0) ObjectDelete(hl_name);
      ObjectCreate(hl_name,OBJ_TEXT,0,time[0],trail_up);
      ObjectSetText(hl_name,(trend<0?"Strong High":"Weak High"),8,"Arial",SwingBearColor);
      string ll_name=prefix+"StrongLow"; if(ObjectFind(ll_name)>=0) ObjectDelete(ll_name);
      ObjectCreate(ll_name,OBJ_TEXT,0,time[0],trail_dn);
      ObjectSetText(ll_name,(trend>0?"Strong Low":"Weak Low"),8,"Arial",SwingBullColor);
     }
   if(ShowSD) DrawPremiumDiscountZones(time,rates_total);
   UpdateDynamicTrendlines(rates_total,time,high,low,close);
  }

void CleanOldOrderBlocks()
  {
   for(int i=iob_size-1;i>=0;i--)
     {
      bool del=false;
      if(iob_type[i]==1 && Close[0]<iob_btm[i]) del=true;
      else if(iob_type[i]==-1 && Close[0]>iob_top[i]) del=true;
      if(del)
        {
         for(int j=i;j<iob_size-1;j++)
           { iob_top[j]=iob_top[j+1]; iob_btm[j]=iob_btm[j+1];
             iob_left[j]=iob_left[j+1]; iob_type[j]=iob_type[j+1]; }
         iob_size--;
        }
     }
   for(int i=ob_size-1;i>=0;i--)
     {
      bool del=false;
      if(ob_type[i]==1 && Close[0]<ob_btm[i]) del=true;
      else if(ob_type[i]==-1 && Close[0]>ob_top[i]) del=true;
      if(del)
        {
         for(int j=i;j<ob_size-1;j++)
           { ob_top[j]=ob_top[j+1]; ob_btm[j]=ob_btm[j+1];
             ob_left[j]=ob_left[j+1]; ob_type[j]=ob_type[j+1]; }
         ob_size--;
        }
     }
  }

void DrawOrderBlocks(bool is_internal,int rates_total,const datetime &time[])
  {
   int ob_sz=is_internal?iob_size:ob_size;
   int show_last=is_internal?IOBShowLast:OBShowLast;
   string pfx=is_internal?"IOB_":"OB_";
   int count=MathMin(show_last,ob_sz);
   for(int i=0;i<count;i++)
     {
      string box_name=prefix+pfx+IntegerToString(i);
      if(ObjectFind(box_name)>=0) ObjectDelete(box_name);
      color box_color;
      double top_val,btm_val; datetime left_val; int type_val;
      if(is_internal)
        { top_val=iob_top[i]; btm_val=iob_btm[i]; left_val=iob_left[i]; type_val=iob_type[i];
          box_color=(type_val==1)?IBullOBColor:IBearOBColor; }
      else
        { top_val=ob_top[i]; btm_val=ob_btm[i]; left_val=ob_left[i]; type_val=ob_type[i];
          box_color=(type_val==1)?BullOBColor:BearOBColor; }
      ObjectCreate(box_name,OBJ_RECTANGLE,0,left_val,top_val,time[0],btm_val);
      ObjectSet(box_name,OBJPROP_COLOR,box_color);
      ObjectSet(box_name,OBJPROP_BACK,true);
      ObjectSet(box_name,OBJPROP_FILL,true);
      ObjectSet(box_name,OBJPROP_WIDTH,1);
     }
  }

void DrawPremiumDiscountZones(const datetime &time[],int rates_total)
  {
   double avg=(trail_up+trail_dn)/2;
   datetime start_time=time[MathMax(top_x,btm_x)];
   datetime end_time=time[0]+PeriodSeconds()*20;
   string premium_name=prefix+"Premium"; if(ObjectFind(premium_name)>=0) ObjectDelete(premium_name);
   ObjectCreate(premium_name,OBJ_RECTANGLE,0,start_time,trail_up,end_time,0.95*trail_up+0.05*trail_dn);
   ObjectSet(premium_name,OBJPROP_COLOR,PremiumColor); ObjectSet(premium_name,OBJPROP_BACK,true); ObjectSet(premium_name,OBJPROP_FILL,true);

   string eq_name=prefix+"Equilibrium"; if(ObjectFind(eq_name)>=0) ObjectDelete(eq_name);
   ObjectCreate(eq_name,OBJ_RECTANGLE,0,start_time,0.525*trail_up+0.475*trail_dn,end_time,0.525*trail_dn+0.475*trail_up);
   ObjectSet(eq_name,OBJPROP_COLOR,EQZoneColor); ObjectSet(eq_name,OBJPROP_BACK,true); ObjectSet(eq_name,OBJPROP_FILL,true);

   string discount_name=prefix+"Discount"; if(ObjectFind(discount_name)>=0) ObjectDelete(discount_name);
   ObjectCreate(discount_name,OBJ_RECTANGLE,0,start_time,0.95*trail_dn+0.05*trail_up,end_time,trail_dn);
   ObjectSet(discount_name,OBJPROP_COLOR,DiscountColor); ObjectSet(discount_name,OBJPROP_BACK,true); ObjectSet(discount_name,OBJPROP_FILL,true);
  }

void UpdateDynamicTrendlines(int rates_total,const datetime &time[],const double &high[],const double &low[],const double &close[])
  {
   double slope=0;
   if(SlopeMethod=="Atr") slope=atr_value/SwingLength*K_Slope;
   else if(SlopeMethod=="Stdev")
     {
      double sum=0; for(int i=0;i<SwingLength && i<ArraySize(close);i++) sum+=close[i];
      double mean=sum/SwingLength; double sum_sq=0;
      for(int i=0;i<SwingLength && i<ArraySize(close);i++) sum_sq+=MathPow(close[i]-mean,2);
      double stdev=MathSqrt(sum_sq/SwingLength);
      slope=stdev/SwingLength*K_Slope;
     }

   string upper_line=prefix+"UpperTrend";
   string lower_line=prefix+"LowerTrend";

   if(top_y>0 && top_x<rates_total)
     {
      double bars_diff=top_x-0;
      double upper=top_y-slope*bars_diff;
      if(ObjectFind(upper_line)>=0)
        { ObjectMove(upper_line,0,time[top_x],top_y); ObjectMove(upper_line,1,time[0],upper); }
      else
        {
         ObjectCreate(upper_line,OBJ_TREND,0,time[top_x],top_y,time[0],upper);
         ObjectSet(upper_line,OBJPROP_COLOR,clrGreen);
         ObjectSet(upper_line,OBJPROP_STYLE,STYLE_DASH);
         ObjectSet(upper_line,OBJPROP_RAY,true);
         ObjectSet(upper_line,OBJPROP_WIDTH,1);
        }
     }

   if(btm_y>0 && btm_x<rates_total)
     {
      double bars_diff=btm_x-0;
      double lower=btm_y+slope*bars_diff;
      if(ObjectFind(lower_line)>=0)
        { ObjectMove(lower_line,0,time[btm_x],btm_y); ObjectMove(lower_line,1,time[0],lower); }
      else
        {
         ObjectCreate(lower_line,OBJ_TREND,0,time[btm_x],btm_y,time[0],lower);
         ObjectSet(lower_line,OBJPROP_COLOR,clrRed);
         ObjectSet(lower_line,OBJPROP_STYLE,STYLE_DASH);
         ObjectSet(lower_line,OBJPROP_RAY,true);
         ObjectSet(lower_line,OBJPROP_WIDTH,1);
        }
     }
  }

void DetectEqualHighsLows(int rates_total,const double &high[],const double &low[],const datetime &time[])
  {
   if(!ShowEQ) return;
   for(int i=EQLen;i<rates_total-EQLen;i++)
     {
      bool is_pivot=true;
      for(int j=1;j<=EQLen;j++)
         if(high[i-j]>=high[i] || high[i+j]>=high[i]){ is_pivot=false; break; }
      if(is_pivot && eq_prev_top>0)
        {
         double diff=MathAbs(high[i]-eq_prev_top);
         if(diff<atr_value*EQThreshold)
           {
            string line=prefix+"EQH_"+IntegerToString(object_counter++);
            ObjectCreate(line,OBJ_TREND,0,time[eq_top_x],eq_prev_top,time[i],high[i]);
            ObjectSet(line,OBJPROP_COLOR,SwingBearColor); ObjectSet(line,OBJPROP_STYLE,STYLE_DOT);
            ObjectSet(line,OBJPROP_RAY,false); ObjectSet(line,OBJPROP_BACK,true);
           }
        }
      if(is_pivot){ eq_prev_top=high[i]; eq_top_x=i; }
     }
   for(int i=EQLen;i<rates_total-EQLen;i++)
     {
      bool is_pivot=true;
      for(int j=1;j<=EQLen;j++)
         if(low[i-j]<=low[i] || low[i+j]<=low[i]){ is_pivot=false; break; }
      if(is_pivot && eq_prev_btm>0)
        {
         double diff=MathAbs(low[i]-eq_prev_btm);
         if(diff<atr_value*EQThreshold)
           {
            string line=prefix+"EQL_"+IntegerToString(object_counter++);
            ObjectCreate(line,OBJ_TREND,0,time[eq_btm_x],eq_prev_btm,time[i],low[i]);
            ObjectSet(line,OBJPROP_COLOR,SwingBullColor); ObjectSet(line,OBJPROP_STYLE,STYLE_DOT);
            ObjectSet(line,OBJPROP_RAY,false); ObjectSet(line,OBJPROP_BACK,true);
           }
        }
      if(is_pivot){ eq_prev_btm=low[i]; eq_btm_x=i; }
     }
  }

void DetectFairValueGaps(int shift,const double &high[],const double &low[],const double &close[],const datetime &time[])
  {
   if(!ShowFVG || shift<2) return;
   double threshold=0;
   if(FVGAuto)
     {
      double sum_delta=0; int count=0;
      for(int i=1;i<MathMin(500,Bars);i++)
        { double delta_per=MathAbs((Close[i]-Open[i])/Open[i]*100); sum_delta+=delta_per; count++; }
      if(count>0) threshold=(sum_delta/count)*2;
     }

   if(low[shift]>high[shift+2] && close[shift+1]>high[shift+2])
     {
      double delta_per=(close[shift+1]-Open[shift+1])/Open[shift+1]*100;
      if(!FVGAuto || delta_per>threshold)
        {
         string name=prefix+"BFVG_"+IntegerToString(object_counter++);
         datetime end_time=time[shift]+PeriodSeconds()*FVGExtend;
         double gap_mid=(low[shift]+high[shift+2])/2;
         ObjectCreate(name+"_up",OBJ_RECTANGLE,0,time[shift+1],low[shift],end_time,gap_mid);
         ObjectSet(name+"_up",OBJPROP_COLOR,BullFVGColor); ObjectSet(name+"_up",OBJPROP_BACK,true); ObjectSet(name+"_up",OBJPROP_FILL,true);
         ObjectCreate(name+"_dn",OBJ_RECTANGLE,0,time[shift+1],gap_mid,end_time,high[shift+2]);
         ObjectSet(name+"_dn",OBJPROP_COLOR,BullFVGColor); ObjectSet(name+"_dn",OBJPROP_BACK,true); ObjectSet(name+"_dn",OBJPROP_FILL,true);
         if(bull_fvg_count<ArraySize(bullish_fvg_names))
           { bullish_fvg_names[bull_fvg_count]=name; bull_fvg_count++; }
        }
     }

   if(high[shift]<low[shift+2] && close[shift+1]<low[shift+2])
     {
      double delta_per=MathAbs((close[shift+1]-Open[shift+1])/Open[shift+1]*100);
      if(!FVGAuto || delta_per>threshold)
        {
         string name=prefix+"SFVG_"+IntegerToString(object_counter++);
         datetime end_time=time[shift]+PeriodSeconds()*FVGExtend;
         double gap_mid=(high[shift]+low[shift+2])/2;
         ObjectCreate(name+"_up",OBJ_RECTANGLE,0,time[shift+1],low[shift+2],end_time,gap_mid);
         ObjectSet(name+"_up",OBJPROP_COLOR,BearFVGColor); ObjectSet(name+"_up",OBJPROP_BACK,true); ObjectSet(name+"_up",OBJPROP_FILL,true);
         ObjectCreate(name+"_dn",OBJ_RECTANGLE,0,time[shift+1],gap_mid,end_time,high[shift]);
         ObjectSet(name+"_dn",OBJPROP_COLOR,BearFVGColor); ObjectSet(name+"_dn",OBJPROP_BACK,true); ObjectSet(name+"_dn",OBJPROP_FILL,true);
         if(bear_fvg_count<ArraySize(bearish_fvg_names))
           { bearish_fvg_names[bear_fvg_count]=name; bear_fvg_count++; }
        }
     }
  }

void CleanFilledFVGs(const double &high[],const double &low[])
  {
   if(!ShowFVG) return;
   for(int i=bull_fvg_count-1;i>=0;i--)
     {
      string up=bullish_fvg_names[i]+"_up";
      string dn=bullish_fvg_names[i]+"_dn";
      if(ObjectFind(dn)>=0 && low[0]<ObjectGetDouble(0,dn,OBJPROP_PRICE2))
        {
         ObjectDelete(up); ObjectDelete(dn);
         for(int j=i;j<bull_fvg_count-1;j++) bullish_fvg_names[j]=bullish_fvg_names[j+1];
         bull_fvg_count--;
        }
     }
   for(int i=bear_fvg_count-1;i>=0;i--)
     {
      string up=bearish_fvg_names[i]+"_up";
      string dn=bearish_fvg_names[i]+"_dn";
      if(ObjectFind(up)>=0 && high[0]>ObjectGetDouble(0,up,OBJPROP_PRICE1))
        {
         ObjectDelete(up); ObjectDelete(dn);
         for(int j=i;j<bear_fvg_count-1;j++) bearish_fvg_names[j]=bearish_fvg_names[j+1];
         bear_fvg_count--;
        }
     }
  }

void DrawMTFHighLow()
  {
   datetime cur=Time[0], ext=cur+PeriodSeconds()*20;
   if(ShowPDHL)
     {
      double h=iHigh(NULL,PERIOD_D1,1), l=iLow(NULL,PERIOD_D1,1);
      datetime t=iTime(NULL,PERIOD_D1,1);
      string hl=prefix+"PDH", ll=prefix+"PDL";
      if(ObjectFind(hl)>=0) ObjectDelete(hl);
      ObjectCreate(hl,OBJ_TREND,0,t,h,ext,h);
      ObjectSet(hl,OBJPROP_COLOR,PDHLColor);
      ObjectSet(hl,OBJPROP_STYLE,GetLineStyle(PDHLStyle));
      ObjectSet(hl,OBJPROP_RAY,false); ObjectSet(hl,OBJPROP_BACK,true);
      string lb=prefix+"PDH_Lbl"; if(ObjectFind(lb)>=0) ObjectDelete(lb);
      ObjectCreate(lb,OBJ_TEXT,0,ext,h); ObjectSetText(lb,"PDH",8,"Arial",PDHLColor);

      if(ObjectFind(ll)>=0) ObjectDelete(ll);
      ObjectCreate(ll,OBJ_TREND,0,t,l,ext,l);
      ObjectSet(ll,OBJPROP_COLOR,PDHLColor);
      ObjectSet(ll,OBJPROP_STYLE,GetLineStyle(PDHLStyle));
      ObjectSet(ll,OBJPROP_RAY,false); ObjectSet(ll,OBJPROP_BACK,true);
      string lbl=prefix+"PDL_Lbl"; if(ObjectFind(lbl)>=0) ObjectDelete(lbl);
      ObjectCreate(lbl,OBJ_TEXT,0,ext,l); ObjectSetText(lbl,"PDL",8,"Arial",PDHLColor);
     }
   if(ShowPWHL)
     {
      double h=iHigh(NULL,PERIOD_W1,1), l=iLow(NULL,PERIOD_W1,1);
      datetime t=iTime(NULL,PERIOD_W1,1);
      string hl=prefix+"PWH", ll=prefix+"PWL";
      if(ObjectFind(hl)>=0) ObjectDelete(hl);
      ObjectCreate(hl,OBJ_TREND,0,t,h,ext,h);
      ObjectSet(hl,OBJPROP_COLOR,PWHLColor);
      ObjectSet(hl,OBJPROP_STYLE,GetLineStyle(PWHLStyle));
      ObjectSet(hl,OBJPROP_RAY,false); ObjectSet(hl,OBJPROP_BACK,true);
      string lb=prefix+"PWH_Lbl"; if(ObjectFind(lb)>=0) ObjectDelete(lb);
      ObjectCreate(lb,OBJ_TEXT,0,ext,h); ObjectSetText(lb,"PWH",8,"Arial",PWHLColor);

      if(ObjectFind(ll)>=0) ObjectDelete(ll);
      ObjectCreate(ll,OBJ_TREND,0,t,l,ext,l);
      ObjectSet(ll,OBJPROP_COLOR,PWHLColor);
      ObjectSet(ll,OBJPROP_STYLE,GetLineStyle(PWHLStyle));
      ObjectSet(ll,OBJPROP_RAY,false); ObjectSet(ll,OBJPROP_BACK,true);
      string lbl=prefix+"PWL_Lbl"; if(ObjectFind(lbl)>=0) ObjectDelete(lbl);
      ObjectCreate(lbl,OBJ_TEXT,0,ext,l); ObjectSetText(lbl,"PWL",8,"Arial",PWHLColor);
     }
   if(ShowPMHL)
     {
      double h=iHigh(NULL,PERIOD_MN1,1), l=iLow(NULL,PERIOD_MN1,1);
      datetime t=iTime(NULL,PERIOD_MN1,1);
      string hl=prefix+"PMH", ll=prefix+"PML";
      if(ObjectFind(hl)>=0) ObjectDelete(hl);
      ObjectCreate(hl,OBJ_TREND,0,t,h,ext,h);
      ObjectSet(hl,OBJPROP_COLOR,PMHLColor);
      ObjectSet(hl,OBJPROP_STYLE,GetLineStyle(PMHLStyle));
      ObjectSet(hl,OBJPROP_RAY,false); ObjectSet(hl,OBJPROP_BACK,true);
      string lb=prefix+"PMH_Lbl"; if(ObjectFind(lb)>=0) ObjectDelete(lb);
      ObjectCreate(lb,OBJ_TEXT,0,ext,h); ObjectSetText(lb,"PMH",8,"Arial",PMHLColor);

      if(ObjectFind(ll)>=0) ObjectDelete(ll);
      ObjectCreate(ll,OBJ_TREND,0,t,l,ext,l);
      ObjectSet(ll,OBJPROP_COLOR,PMHLColor);
      ObjectSet(ll,OBJPROP_STYLE,GetLineStyle(PMHLStyle));
      ObjectSet(ll,OBJPROP_RAY,false); ObjectSet(ll,OBJPROP_BACK,true);
      string lbl=prefix+"PML_Lbl"; if(ObjectFind(lbl)>=0) ObjectDelete(lbl);
      ObjectCreate(lbl,OBJ_TEXT,0,ext,l); ObjectSetText(lbl,"PML",8,"Arial",PMHLColor);
     }
  }

int GetLineStyle(string style)
  {
   if(style=="Solid") return STYLE_SOLID;
   if(style=="Dash") return STYLE_DASH;
   if(style=="Dot") return STYLE_DOT;
   return STYLE_SOLID;
  }

void UpdateStructureLines()
  {
   if(structure_line_count==0) return;
   datetime cur=Time[0];
   for(int i=0;i<structure_line_count;i++)
     {
      string name=structure_line_names[i];
      double price=structure_line_prices[i];
      if(ObjectFind(name)>=0)
        { ObjectSet(name,OBJPROP_TIME2,cur); ObjectSet(name,OBJPROP_PRICE2,price); }
     }
  }

void CleanCrossedStructureLines()
  {
   if(structure_line_count==0 || Bars<2) return;
   for(int i=structure_line_count-1;i>=0;i--)
     {
      string name=structure_line_names[i];
      double price=structure_line_prices[i];
      if(ObjectFind(name)<0){ RemoveStructureLineFromArray(i); continue; }
      bool crossed=false;
      if(Close[1]<price && Close[0]>=price) crossed=true;
      if(Close[1]>price && Close[0]<=price) crossed=true;
      if(crossed)
        {
         ObjectSet(name,OBJPROP_TIME2,Time[0]);
         ObjectSet(name,OBJPROP_PRICE2,price);
         RemoveStructureLineFromArray(i);
        }
     }
  }

void RemoveStructureLineFromArray(int index)
  {
   for(int j=index;j<structure_line_count-1;j++)
     {
      structure_line_names[j]=structure_line_names[j+1];
      structure_line_prices[j]=structure_line_prices[j+1];
     }
   structure_line_count--;
  }
//+------------------------------------------------------------------+
/*
── Project ─────────────────────────────────────────────────────────────────────

Name:        RoyalPrince_SMC
Version:     1.00
Date:        2025
Repository:  Available @ https://fxcodebase.com/code/viewtopic.php?f=38&t=76432&p=161150#p161150
License:     GNU

── Author ──────────────────────────────────────────────────────────────────────

Developed by: Mario Jemic
Email:        mario.jemic@gmail.com
Website:      https://mario-jemic.com

── Support & Donations ─────────────────────────────────────────────────────────

PayPal:      https://goo.gl/9Rj74e
Patreon:     https://tiny.cc/1ybwxz
BuyMeACoffee:https://tiny.cc/bj7vzj

Crypto:
 BTC : 16F5k43RXibTmna4np8bPVgmXM1CzjXFJJ
 SOL : 3nh5rpUKopcYLNU4zGCdUFAkM3iRQq8VVUmuzVG6VDf2
 ETH/BNB/USDT/XRP (ERC20/BEP20): 0xe53aab6bc468a963a02d1319660ee60cf80fc8e7

── Copyright ───────────────────────────────────────────────────────────────────

© 2025 Gehtsoft USA LLC — https://fxcodebase.com

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 <https://www.gnu.org/licenses/>.
*/
